IF  EXISTS (SELECT 1 FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_GLB_PRODUTO_BENNER]'))
	DROP VIEW [dbo].[V_GLB_PRODUTO_BENNER]
GO


CREATE VIEW [dbo].[V_GLB_PRODUTO_BENNER]
AS SELECT
		newid()		AS ID,
		ep.CD_PROD,
		ep.CD_EMP,
		pf.CD_FILIAL,
		'SESI' AS EMPRESA,
		PF.CGC AS CNPJFILIAL,
		EP.NR_CEST AS CODIGOCEST,
		EPCB.CD_BARRA AS CODIGOBARRAS,
		SUBSTRING (EP.NR_NCM, 1, 2)AS CODIGOGENERO,
		EP.NR_NCM AS CODIGONCM,
		CASE 
		   WHEN LEN(EP.CD_PROD) > 5 THEN CONVERT (INT, SUBSTRING('9900000000',1, (9 - LEN(CONVERT(VARCHAR,EP.CD_PROD)))) + CONVERT(VARCHAR,EP.CD_PROD))
		   ELSE CONVERT (INT, SUBSTRING('990000000',1, (8 - LEN(CONVERT(VARCHAR,EP.CD_PROD)))) + CONVERT(VARCHAR,EP.CD_PROD)) 
		END AS CODIGOPRODUTO,
		EPUM.DS_UN UNIDADEMEDIDA,
		CASE
			WHEN EP.CD_CLASS_FISC IN (19) THEN 'MATERIAL DE USO E CONSUMO'
			WHEN EP.CD_CLASS_FISC IN (24) THEN 'ATIVO IMOBILIZADO'
			WHEN EP.CD_CLASS_FISC IN ( 23, 25 ) THEN 'SERVICOS'
			ELSE 0
		END AS TIPO_PRODUTO,
		EP.DS_USUAL AS NOME_PRODUTO,
		CASE
			WHEN EP.CD_CLASS_FISC IN (19) THEN 'MATERIAL DE USO E CONSUMO'
			WHEN EP.CD_CLASS_FISC IN (24) THEN 'ATIVO IMOBILIZADO'
			WHEN EP.CD_CLASS_FISC IN ( 23, 25 ) THEN 'SERVICOS'
			ELSE 0
		END AS TIPOITEM,
		'EST_PROD' AS TABELA_REGISTRO,
		'' AS TOKEN_ID
	FROM
		EST_PROD EP
		INNER JOIN PRC_FILIAL PF ON
			(EP.CD_EMP = PF.CD_EMP AND PF.STS_FILIAL = 0
			 )
		LEFT JOIN EST_PROD_CD_BARRA EPCB ON
			(EPCB.CD_PROD = EP.CD_PROD
			AND EPCB.CD_EMP = EP.CD_EMP )
		INNER JOIN EST_PROD_UN_MED EPUM ON
			(EPUM.CD_CTR_UN = EP.CD_UN_VD
			AND EPUM.CD_EMP = EP.CD_EMP )
		INNER JOIN EST_TRIB_CLASS_FISC ETCF ON
			(ETCF.CD_CLASS_FISC = EP.CD_CLASS_FISC)

	GROUP BY 
		ep.CD_PROD,
		ep.CD_EMP,
		pf.CD_FILIAL,
		PF.CGC ,
		EP.NR_CEST ,
		EPCB.CD_BARRA ,
		EP.NR_NCM ,
		EP.DS_USUAL ,
		EP.CD_CLASS_FISC,
		EPUM.DS_UN 
GO


